<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }

    function precios_mercado_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un registro en específico, o vacío para obtener todas los registros"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_mercadoPrecios', array('idPrecioMercado' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_mercadoPrecios');
            }
        }
        $this->response($response, $response['status_code']);
    }

    function precios_mercado_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "productoId" => "El campo es requerido.",
                    "fecha" => "El campo es requerido.",
                    "precio" => "El campo es requerido.",
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('productoId', 'productoId', 'required');
            $this->form_validation->set_rules('fecha', 'fecha', 'required');
            $this->form_validation->set_rules('precio', 'precio', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {

                $data = array(
                    "productoId" => $this->post('productoId'),
                    "fecha" => $this->post('fecha'),
                    "precio" => $this->post('precio')
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('precios_mercado', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Precio de mercado registrado exitosamente",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }


    function precios_mercado_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('precios_mercado', array('idPrecioMercado' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 10) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "productoId" => "El campo es requerido.",
                            "fecha" => "El campo es requerido.",
                            "precio" => "El campo es requerido.",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "productoId" => "El campo es requerido.",
                            "fecha" => "El campo es requerido.",
                            "precio" => "El campo es requerido.",
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('productoId', 'productoId', 'required');
                    $this->form_validation->set_rules('fecha', 'fecha', 'required');
                    $this->form_validation->set_rules('precio', 'precio', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        $data = array(
                            "productoId" => $this->put('productoId'),
                            "fecha" => $this->put('fecha'),
                            "precio" => $this->put('precio')
                        );

                        $this->DAO->saveOrUpdateItem('precios_mercado', $data, array('idPrecioMercado' => $id));
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Registro actualizado exitosamente",
                            "validations" => array(
                                "id" => "Requerido",
                            ),
                            "data" => null
                        );
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    //selecciona un producto para eliminar
    function precios_mercado_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('precios_mercado', array('idPrecioMercado' => $id), TRUE);
            if ($dataExists['data']) {
                $response=$this->DAO->deleteData('precios_mercado', array('idPrecioMercado' => $id));
                
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El id de registro no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Ningun id fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
}
