<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        /*   $this->load->library('ciqrcode'); */
    }

    //obtner los presentaciones
    function presentaciones_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('presentaciones', array('presentacionID' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('presentaciones', array('presentacionStatus'=>1));
            }
        }
        $this->response($response, $response['status_code']);
    }
    


    function presentaciones_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "presentacionNombre" => "Requerido",
                    "presentacionCantidad" => "Opcional"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('presentacionNombre', 'presentacionNombre', 'required');
            $this->form_validation->set_rules('presentacionCantidad', 'presentacionCantidad', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "presentacionNombre" => $data["presentacionNombre"],
                    "presentacionCantidad" =>$data["presentacionCantidad"],
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('presentaciones', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Presentacion registrada exitosamente",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }
  
    //actualizar ls datos en la bd
    function presentaciones_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('presentaciones', array('presentacionID' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 15) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "presentacionNombre" => "Requerido",
                            "presentacionCantidad" => "Requerido"
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "presentacionNombre" => "Requerido",
                            "presentacionCantidad" => "Requerido"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('presentacionNombre', 'presentacionNombre', 'required');
                    $this->form_validation->set_rules('presentacionCantidad', 'presentacionCantidad', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->put(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "presentacionNombre" => $this->put('presentacionNombre'),
                            "presentacionCantidad" => $this->put('presentacionCantidad'),
                        );

                        $response = $this->DAO->updateData('presentaciones', $data, array('presentacionID' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    //Funcion para eliminar(Eliminado logico)
    function presentaciones_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('presentaciones', array('presentacionID' => $id), TRUE);
            if ($dataExists['data']) {
                $data = array(
                    "presentacionStatus" => 0,
                );
                $response = $this->DAO->updateData('presentaciones', $data, array('presentacionID' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El presentacion especificada no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de presentacion no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }



}
