<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        /*   $this->load->library('ciqrcode'); */
    }

    //obtner los productos
    function productos_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_products', array('id_producto' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_products');
            }
        }
        $this->response($response, $response['status_code']);
    }
    //obtner los productos desactivados
    function productos_inactivos_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_products', array('id_producto' => $id, 'status' => 0), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_products', array('status' => 0));
            }
        }
        $this->response($response, $response['status_code']);
    }
    //agregar productos
    function getProductByCategory_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                'status' => 'error',
                'status_code' => 409,
                'message' => 'Se enviaron demasiados parámetros',
                'validations' => array(
                    'id' => 'Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos'
                ),
                'data' => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_products', array('id_categoria' => $id), FALSE);
            }
        }
        $this->response($response, $response['status_code']);
    }

    function productos_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "nombre" => "Requerido",
                    "descripcion" => "Opcional"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('nombre', 'nombre', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "nombre_producto" => $this->post('nombre'),
                    "descripcion" => $this->post('descripcion'),
                    "precio" => $this->post('precio'),
                    "inventario" => $this->post('inventario'),
                    "id_categoria" => $this->post('categoria'),
                    "raza" => $this->post('raza'),
                    "productos_create" => $currentDate,
                    "productos_update" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('productos', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Producto registrado exitosamente",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }
    function activar_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos', array('id_producto' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 1,
                    "productos_update" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('productos', $data, array('id_producto' => $id));
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'El producto fue activado exitosamente',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de producto no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    //actualizar ls datos en la bd
    function productos_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos', array('id_producto' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 15) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "nombre" => "Requerido",
                            "descripcion" => "Opcional",
                            "precio" => "Requerido",
                            "inventario" => "Opcional",
                            "id_categoria" => "Opcional",
                            "raza" => "Opcional",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "nombre" => "Requerido",
                            "descripcion" => "Opcional",
                            "precio" => "Requerido",
                            "inventario" => "Opcional",
                            "id_categoria" => "Opcional",
                            "raza" => "Opcional",
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('nombre', 'nombre', 'required');
                    $this->form_validation->set_rules('categoria', 'categoria', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->put(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "nombre_producto" => $this->put('nombre'),
                            "descripcion" => $this->put('descripcion'),
                            "precio" => $this->put('precio'),
                            "inventario" => $this->put('inventario'),
                            "id_categoria" => $this->put('categoria'),
                            "raza" => $this->put('raza'),
                            "productos_update" => $currentDate
                        );

                        $response = $this->DAO->updateData('productos', $data, array('id_producto' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function actualizar_foto_post()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos', array('id_producto' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $file = time();
                $config['upload_path'] = 'uploads';
                $config['allowed_types'] = '*';
                $config['max_size'] = '0';
                $config['overwrite'] = TRUE;
                $config['file_name'] = $file;

                $this->load->library('upload', $config);
                if ($this->upload->do_upload("img_product")) {
                    $doc_data = array('upload_data' => $this->upload->data());
                    $imagen = $doc_data['upload_data']['file_name'];
                }
                $data = array(
                    "productos_update" => $currentDate,
                    "imagen" => $imagen
                );

                $response = $this->DAO->updateData('productos', $data, array('id_producto' => $id));
            }
        }
        $this->response($response, $response['status_code']);
    }

    //selecciona un producto para eliminar
    function productos_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos', array('id_producto' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 0,
                    "productos_update" => $currentDate,
                );
                $response = $this->DAO->updateData('productos', $data, array('id_producto' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El producto especificado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de cliente no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    /* eliminado fisico productos */
    function eliminar_producto_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos', array('id_producto' => $id), TRUE);
            if ($dataExists['data']) {
                $productExists = $this->DAO->selectEntity('productos_ventas', array('id_producto' => $id), TRUE);
                if ($productExists['data']) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "No se puede eliminar el producto seleccionado porque pertenece a ventas realizadas",
                        "validations" => null,
                        "data" => null
                    );
                } else {
                    $productExists = $this->DAO->selectEntity('ventas', array('id_producto' => $id), TRUE);
                    if ($productExists['data']) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "No se puede eliminar el producto seleccionado porque pertenece a ventas realizadas",
                            "validations" => null,
                            "data" => null
                        );
                    } else {
                        $this->DAO->deleteData('productos', array('id_producto' => $id));
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Producto eliminado exitosamente",
                            "validations" => null,
                            "data" => null
                        );
                    }
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El producto seleccionado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Ningun id fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    /**exta validations**/
}
