<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->model('MovimientoModelo');
    }

    function reportes_post()
    {
        $data = $this->post();
        if (count($data) > 0) {
            if ($data['tipo_movimiento'] == 'Entrada' || $data['tipo_movimiento'] == 'Salida') {
                $tipo_movimiento = $data['tipo_movimiento'];
                if ($data['filtrar_por_fecha'] == 'si') {
                    $fecha_inicio = $data['fecha_inicio'];
                    $fecha_termino = $data['fecha_termino'];
                    if ($data['filtrar_por_almacen'] == 'todo') {
                        $query = $this->db->query("SELECT * FROM vw_movimiento  WHERE  (movimientoFecha BETWEEN '$fecha_inicio' AND '$fecha_termino') AND movimientoTipo='$tipo_movimiento' AND movimientoStatus=1 ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    } else {
                        $almacenId = $data['filtrar_por_almacen'];
                        $query = $this->db->query("SELECT * FROM vw_movimiento  WHERE  (movimientoFecha BETWEEN '$fecha_inicio' AND '$fecha_termino') AND almacenId='$almacenId' AND movimientoTipo='$tipo_movimiento' AND movimientoStatus=1 ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    }
                } else {
                    if ($data['filtrar_por_almacen'] == 'todo') {
                        $query = $this->db->query("SELECT * FROM vw_movimiento  WHERE  movimientoStatus=1 AND movimientoTipo='$tipo_movimiento' ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    } else {
                        $almacenId = $data['filtrar_por_almacen'];
                        $query = $this->db->query("SELECT * FROM vw_movimiento  WHERE  movimientoTipo='$tipo_movimiento' AND  almacenId='$almacenId' AND movimientoStatus=1 ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    }
                }
            } else if ($data['tipo_movimiento'] == 'Traspaso') {

                if ($data['filtrar_por_fecha'] == 'si') {
                    $fecha_inicio = $data['fecha_inicio'];
                    $fecha_termino = $data['fecha_termino'];
                    if ($data['filtrar_por_tipo_almacen'] == 'almacen_origen') {
                        $almacen_origen = $data['almacen_origen'];
                        $query = $this->db->query("SELECT * FROM vw_traspaso  WHERE  (movimientoFecha BETWEEN '$fecha_inicio' AND '$fecha_termino') AND movimientoStatus=1 AND almacenOrigen='$almacen_origen' ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    } else if ($data['filtrar_por_tipo_almacen'] == 'almacen_destino') {
                        $almacen_destino = $data['almacen_destino'];
                        $query = $this->db->query("SELECT * FROM vw_traspaso  WHERE  (movimientoFecha BETWEEN '$fecha_inicio' AND '$fecha_termino') AND movimientoStatus=1 AND almacenDestino='$almacen_destino' ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    } else {
                        $query = $this->db->query("SELECT * FROM vw_traspaso  WHERE  (movimientoFecha BETWEEN '$fecha_inicio' AND '$fecha_termino') AND movimientoStatus=1 ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    }
                } else {
                    if ($data['filtrar_por_tipo_almacen'] == 'almacen_origen') {
                        $almacen_origen = $data['almacen_origen'];
                        $query = $this->db->query("SELECT * FROM vw_traspaso  WHERE  movimientoStatus=1 AND almacenOrigen='$almacen_origen' ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    } else if ($data['filtrar_por_tipo_almacen'] == 'almacen_destino') {
                        $almacen_destino = $data['almacen_destino'];
                        $query = $this->db->query("SELECT * FROM vw_traspaso  WHERE  movimientoStatus=1 AND almacenDestino='$almacen_destino' ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    } else {
                        $query = $this->db->query("SELECT * FROM vw_traspaso  WHERE movimientoStatus=1 ORDER BY movimientoFecha ASC");
                        $resultData = $query->result();
                    }
                }
            } else {
                /* todo */
                if ($data['filtrar_por_fecha'] == 'si') {
                    //si
                    $fecha_inicio = $data['fecha_inicio'];
                    $fecha_termino = $data['fecha_termino'];
                    $query = $this->db->query("SELECT * FROM vw_transferencias  WHERE  (movimientoFecha BETWEEN '$fecha_inicio' AND '$fecha_termino') AND movimientoStatus=1 ORDER BY movimientoFecha ASC");
                    $resultData = $query->result();
                } else {
                    $query = $this->db->query("SELECT * FROM vw_transferencias  WHERE  movimientoStatus=1 ORDER BY movimientoFecha ASC");
                    $resultData = $query->result();
                }
            }

            if ($resultData) {
                /* $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" => "Datos cargados correctamente",
                    "validations" => null,
                    "data" => $resultData
                ); */
                if ($data['tipo_reporte'] == 'pdf') {
                    $result = $this->generar_pdf($data, $resultData);
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => "Datos cargados correctamente",
                        "validations" => null,
                        "data" => array(
                            'folder_mame' => $result['folder_name'],
                            'file_name' => $result['file_name']
                        )
                    );
                } else {
                    $result = $this->generar_excel($data, $resultData);
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => "Datos cargados correctamente",
                        "validations" => null,
                        "data" => array(
                            'folder_mame' => $result['folder_name'],
                            'file_name' => $result['file_name']
                        )
                    );
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "No se han encontrado información con los filtros seleccionados, ingrese otros datos",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "No se ha enviado ningún dato, por favor envie datos",
                "validations" => array(
                    'tipo_movimiento' => 'El tipo debe ser todo, Entrada, Salida o Traspaso',
                    'filtrar_por_fecha' => 'Filtrar por fecha debe ser si o no',
                    'fecha_inicio' => 'Fecha de inicio en caso de que filtrar por fecha sea si',
                    'fecha_termino' => 'Fecha de termino en caso de que filtrar por fecha sea si',
                    'filtrar_por_almacen' => 'Filtrar por almacen debe ser todo o enviar el id del almacen. Solo aplica para entradas o salidas',
                    'filtrar_por_tipo_almacen' => 'Filtrar por tipo de almacen debe ser todo, almacen_origen o almacen_destino. Solo aplica para traspasos',
                    'almacen_origen' => 'El almacen de origen solo aplica si se va a filtrar por tipo de almacen de origen',
                    'almacen_destino' => 'El almacen de destino solo aplica si se va a filtrar por tipo de almacen de destino',
                    'tipo_reporte' => 'El tipo de reporte debe ser excel o pdf'
                ),
                "data" => null
            );
        }


        $this->response($response, $response['status_code']);
    }

    public function generar_pdf($dataQuery, $dataTransaction)
    {

        setlocale(LC_TIME, "es_MX.UTF8");
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $header = $this->load->view('reportes/header', array('general_info' => $dataQuery, 'infoTransaction' => $dataTransaction[0]), true);
        $mpdf->SetHTMLHeader($header);
        $footer = $this->load->view('reportes/footer', [], true);
        $mpdf->SetHTMLFooter($footer);
        $html = $this->load->view('reportes/body', array('dataTransaction' => $dataTransaction, 'general_info' => $dataQuery), true);
        $css = file_get_contents('assets/pdf-reports.css');
        $mpdf->SetTitle('Reporte de huevo');
        $mpdf->WriteHTML('<body>');
        $mpdf->WriteHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $file_name = 'reporte_de_movimientos_huevo_ranchoelarenal' . date("Ymd") . '_' . uniqid() . '.pdf';
        $folder_name = 'reportes';
        $mpdf->Output("{$folder_name}/{$file_name}", 'F');

        return array(
            'folder_name' => $folder_name,
            'file_name' => $file_name
        );
    }

    public function generar_excel($dataQuery, $dataTransaction)
    {
        $general_info = $dataQuery;
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png');
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);

        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
        $sheet->mergeCells('A1:K4');
        $sheet->mergeCells('A5:E6');

        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

        $sheet->getStyle('A1')->getAlignment()->setVertical('center');

        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('F5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('F5:K6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('F5:K6')->getAlignment()->setWrapText(true);

        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("F5:K6")->getFont()->setBold(true);



        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];


        $sheet->setCellValue('A1', 'Reporte de movimientos de almacenes de huevo');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');


        if ($general_info['filtrar_por_fecha'] == 'si') {
            $sheet->setCellValue('F5', 'Desde: ' . $general_info['fecha_inicio']);
            $sheet->setCellValue('F6',  'Hasta: ' . $general_info['fecha_termino']);
        }

        $sheet->setCellValue('G5',  'Tipo: ' . $general_info['tipo_movimiento']);
        if ($general_info['tipo_movimiento'] == 'Entrada' || $general_info['tipo_movimiento'] == 'Salida') {
            $sheet->setCellValue('G6', 'Almacen: ' . ($general_info['filtrar_por_almacen'] != 'todo') ? $dataTransaction[0]->almacen : 'Todos');
        }
        if ($general_info['tipo_movimiento'] == 'Traspaso') {
            if ($general_info['filtrar_por_tipo_almacen'] == 'almacen_origen') {
                $sheet->setCellValue('G6',  'Almacen Origen: ' . $dataTransaction[0]->almacenOrigenNombre);
            } else if ($general_info['filtrar_por_tipo_almacen'] == 'almacen_destino') {
                $sheet->setCellValue('G6',  'Almacen Destino: ' . $dataTransaction[0]->almacenDestinoNombre);
            }
        }
        $sheet->setCellValue('H5',  'NA = No Aplica');
        $counter = 8;
        if ($general_info['tipo_movimiento'] == 'todo') {
            $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);


            $sheet->getColumnDimension('A')->setWidth(10);
            $sheet->getColumnDimension('B')->setWidth(20);
            $sheet->getColumnDimension('C')->setWidth(20);
            $sheet->getColumnDimension('D')->setWidth(20);
            $sheet->getColumnDimension('E')->setWidth(20);
            $sheet->getColumnDimension('F')->setWidth(20);
            $sheet->getColumnDimension('G')->setWidth(20);
            $sheet->getColumnDimension('H')->setWidth(20);
            $sheet->getColumnDimension('I')->setWidth(35);


            $sheet->setCellValue('A8', 'N°');
            $sheet->setCellValue('B8', 'Fecha');
            $sheet->setCellValue('C8', 'Tipo');
            $sheet->setCellValue('D8', 'Producto');
            $sheet->setCellValue('E8', 'Cantidad');
            $sheet->setCellValue('F8', 'Almacen');
            $sheet->setCellValue('G8', 'Almacen Origen');
            $sheet->setCellValue('H8', 'Almacen Destino');
            $sheet->setCellValue('I8', 'Comentarios');

            foreach ($dataTransaction as $i => $data) {
                $counter = $counter + 1;
                $i = $i + 1;
                $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("I{$counter}")->getAlignment()->setWrapText(true);

                $sheet->setCellValue("A{$counter}", $i);
                $sheet->setCellValue("B{$counter}", $data->movimientoFecha);
                $sheet->setCellValue("C{$counter}", $data->movimientoTipo);
                $sheet->setCellValue("D{$counter}", $data->producto);
                $sheet->setCellValue("E{$counter}", $data->movimientoCantidad);
                $sheet->setCellValue("F{$counter}", ($data->almacen) ? $data->almacen : 'NA');
                $sheet->setCellValue("G{$counter}", ($data->almacenOrigenNombre) ? $data->almacenOrigenNombre : 'NA');
                $sheet->setCellValue("H{$counter}", ($data->almacenDestinoNombre) ? $data->almacenDestinoNombre : 'NA');
                $sheet->setCellValue("I{$counter}", ($data->movimientoNotas) ? $data->movimientoNotas : '---');
            }
        } else if ($general_info['tipo_movimiento'] == 'Entrada' || $general_info['tipo_movimiento'] == 'Salida') {
            $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);


            $sheet->getColumnDimension('A')->setWidth(10);
            $sheet->getColumnDimension('B')->setWidth(20);
            $sheet->getColumnDimension('C')->setWidth(20);
            $sheet->getColumnDimension('D')->setWidth(20);
            $sheet->getColumnDimension('E')->setWidth(20);
            $sheet->getColumnDimension('F')->setWidth(20);
            $sheet->getColumnDimension('G')->setWidth(35);


            $sheet->setCellValue('A8', 'N°');
            $sheet->setCellValue('B8', 'Fecha');
            $sheet->setCellValue('C8', 'Tipo');
            $sheet->setCellValue('D8', 'Producto');
            $sheet->setCellValue('E8', 'Cantidad');
            $sheet->setCellValue('F8', 'Almacen');
            $sheet->setCellValue('G8', 'Comentarios');

            foreach ($dataTransaction as $i => $data) {
                $counter = $counter + 1;
                $i = $i + 1;
                $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("G{$counter}")->getAlignment()->setWrapText(true);

                $sheet->setCellValue("A{$counter}", $i);
                $sheet->setCellValue("B{$counter}", $data->movimientoFecha);
                $sheet->setCellValue("C{$counter}", $data->movimientoTipo);
                $sheet->setCellValue("D{$counter}", $data->producto);
                $sheet->setCellValue("E{$counter}", $data->movimientoCantidad);
                $sheet->setCellValue("F{$counter}", ($data->almacen) ? $data->almacen : 'NA');
                $sheet->setCellValue("G{$counter}", ($data->movimientoNotas) ? $data->movimientoNotas : '---');
            }
        } else  if ($general_info['tipo_movimiento'] == 'Traspaso') {
            $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);


            $sheet->getColumnDimension('A')->setWidth(10);
            $sheet->getColumnDimension('B')->setWidth(20);
            $sheet->getColumnDimension('C')->setWidth(20);
            $sheet->getColumnDimension('D')->setWidth(20);
            $sheet->getColumnDimension('E')->setWidth(20);
            $sheet->getColumnDimension('F')->setWidth(20);
            $sheet->getColumnDimension('G')->setWidth(20);
            $sheet->getColumnDimension('H')->setWidth(35);


            $sheet->setCellValue('A8', 'N°');
            $sheet->setCellValue('B8', 'Fecha');
            $sheet->setCellValue('C8', 'Tipo');
            $sheet->setCellValue('D8', 'Producto');
            $sheet->setCellValue('E8', 'Cantidad');
            $sheet->setCellValue('F8', 'Almacen Origen');
            $sheet->setCellValue('G8', 'Almacen Destino');
            $sheet->setCellValue('H8', 'Comentarios');

            foreach ($dataTransaction as $i => $data) {
                $counter = $counter + 1;
                $i = $i + 1;
                $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
                $sheet->getStyle("H{$counter}")->getAlignment()->setWrapText(true);

                $sheet->setCellValue("A{$counter}", $i);
                $sheet->setCellValue("B{$counter}", $data->movimientoFecha);
                $sheet->setCellValue("C{$counter}", $data->movimientoTipo);
                $sheet->setCellValue("D{$counter}", $data->producto);
                $sheet->setCellValue("E{$counter}", $data->movimientoCantidad);
                $sheet->setCellValue("F{$counter}", ($data->almacenOrigenNombre) ? $data->almacenOrigenNombre : 'NA');
                $sheet->setCellValue("G{$counter}", ($data->almacenDestinoNombre) ? $data->almacenDestinoNombre : 'NA');
                $sheet->setCellValue("H{$counter}", ($data->movimientoNotas) ? $data->movimientoNotas : '---');
            }
        }



        $writer = new Xlsx($spreadsheet);

        $file_name = 'reporte_de_movimientos_huevo_ranchoelarenal' . date("Ymd") . '_' . uniqid() . '.xlsx';
        /* $file_name = 'test.xlsx'; */
        $folder_name = 'reportes';
        $writer->save("{$folder_name}/{$file_name}");
        return array(
            'folder_name' => $folder_name,
            'file_name' => $file_name
        );
    }
}
