<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->model('TraspasosModelo');
        /*   $this->load->library('ciqrcode'); */
    }

    //obtner los traspasos
    function traspasos_get()
    {
        $page = $this->get('page');
        $limit = $this->get('limit');
        $id = $this->get('id');
        if (count($this->get()) > 3) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_traspaso', array('movimientoId' => $id), TRUE);
            } else {
                $response = $this->TraspasosModelo->obtenerTraspasos($page, $limit);
            }
        }
        $this->response($response, $response['status_code']);
    }



    function traspasos_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "movimientoFecha" => "El campo fecha es requerido.",
                    "almacenOrigen" => "El campo origen es requerido.",
                    "almacenDestino" => "El campo destino es requerido.",
                    "movimientoCantidad" => "El campo cantidad es requerido.",
                    "movimientoNotas" => "El campo notas es opcional"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('movimientoFecha', 'fecha', 'required');
            $this->form_validation->set_rules('almacenOrigen', 'origen', 'required|callback_almacen_exists');
            $this->form_validation->set_rules('almacenDestino', 'destino', 'required|callback_almacen_exists');
            $this->form_validation->set_rules('movimientoCantidad', 'cantidad', 'required|callback_cantidad_valid');
            $this->form_validation->set_message('required', 'El campo {field} es requerido.');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {

                $almacenOrigen = $data["almacenOrigen"];
                $almacenDestino = $data["almacenDestino"];
                $cantidadMovimiento = $data["movimientoCantidad"];
                $productoId = 10;
                if ($almacenOrigen == $almacenDestino) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Validaciones fallidas",
                        "data" => null,
                        "validations" => array(
                            "almacenDestino" => "El almacen de destino no puede ser el mismo almacen de origen",
                        )
                    );
                } else {
                    $contenidoAlmacenOrigen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenOrigen), TRUE);
                    if ($contenidoAlmacenOrigen['data']) {
                        $cantidadAlmacenOrigen = $contenidoAlmacenOrigen['data']->contenidoCantidad;
                        if ($cantidadMovimiento > $cantidadAlmacenOrigen) {
                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" => "Validaciones fallidas",
                                "validations" => array(
                                    "movimientoCantidad" => "No hay suficiente contenido en el almacen de origen seleccionado, por favor ingrese otra cantidad o seleccione otro almacen.",
                                ),
                                "data" => null
                            );
                        } else {
                            date_default_timezone_set('America/Mexico_City');
                            $currentDate = date('Y-m-d H:i:s');
                            $dataTraspaso = array(
                                "movimientoFecha" => $data["movimientoFecha"],
                                "movimientoTipo" => "Traspaso",
                                "almacenOrigen" => $almacenOrigen,
                                "almacenDestino" => $almacenDestino,
                                "productoId" => $productoId,
                                "movimientoCantidad" => $cantidadMovimiento,
                                "movimientoNotas" => (@$data["movimientoNotas"]) ? $data["movimientoNotas"] : "",
                                "movimientoUsuarioRegistro" => (@$data["movimientoUsuarioRegistro"]) ? $data["movimientoUsuarioRegistro"] : '',
                                "movimientoFechaRegistro" => $currentDate,
                                "movimientoFechaActualizacion" => $currentDate,
                            );
                            $dataResponse = $this->DAO->saveOrUpdateItem('movimientos', $dataTraspaso, null, true);
                            if ($dataResponse['status'] == 'success' && $dataResponse['key']) {
                                $id_movimiento = $dataResponse['key'];
                                $dataDetalles = array(
                                    'movimiento_id' => $id_movimiento,
                                    'detalleCantidad' => $cantidadMovimiento,
                                    'detalleNotas' => "",
                                    'detallesFechaRegistro' => $currentDate,
                                    'detallesFechaActualizacion' => $currentDate
                                );
                                $detallesResponse = $this->DAO->saveOrUpdateItem('detalles_movimientos', $dataDetalles, null, true);
                                if ($detallesResponse['status'] == 'success') {

                                    $totalCantidadAlmacenOrigen = $cantidadAlmacenOrigen - $cantidadMovimiento;
                                    $dataContenido = array(
                                        "productoID" => $productoId,
                                        "contenidoCantidad" => $totalCantidadAlmacenOrigen,
                                        "contenidoFechaActualizacion" => $currentDate
                                    );
                                    $responseContenidoAlmacenOrigen = $this->DAO->updateData('contenido_almacen', $dataContenido, array('almacenID' => $almacenOrigen));
                                    if ($responseContenidoAlmacenOrigen['status'] == 'success') {
                                        $contenidoAlmacenDestino = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenDestino), TRUE);
                                        if ($contenidoAlmacenDestino['data']) {
                                            $cantidadAlmacenDestino = $contenidoAlmacenDestino['data']->contenidoCantidad;
                                            $totalCantidadAlmacenDestino = $cantidadAlmacenDestino + $cantidadMovimiento;
                                            $dataContenidoAlmacenDestino = array(
                                                "productoID" => $productoId,
                                                "contenidoCantidad" => $totalCantidadAlmacenDestino,
                                                "contenidoFechaActualizacion" => $currentDate
                                            );
                                            $responseContenidoAlmacenDestino = $this->DAO->updateData('contenido_almacen', $dataContenidoAlmacenDestino, array('almacenID' => $almacenDestino));
                                            if ($responseContenidoAlmacenDestino['status'] == 'success') {
                                                $response = array(
                                                    "status" => "success",
                                                    "status_code" => 200,
                                                    "message" =>  "Trasferencia registrada exitosamente",
                                                    "data" => null,
                                                );
                                            } else {
                                                $response = array(
                                                    "status" => "error",
                                                    "status_code" => 409,
                                                    "message" =>  $responseContenidoAlmacenDestino['message'],
                                                    "data" => null,
                                                );
                                            }
                                        } else {
                                            $response = array(
                                                "status" => "error",
                                                "status_code" => 409,
                                                "message" =>  $contenidoAlmacenDestino['message'],
                                                "data" => null,
                                            );
                                        }
                                    } else {
                                        $response = array(
                                            "status" => "error",
                                            "status_code" => 409,
                                            "message" =>  $responseContenidoAlmacenOrigen['message'],
                                            "data" => null,
                                        );
                                    }
                                } else {
                                    $response = array(
                                        "status" => "error",
                                        "status_code" => 409,
                                        "message" =>  $detallesResponse['message'],
                                        "data" => null,
                                    );
                                }
                            } else {
                                $response = array(
                                    "status" => "error",
                                    "status_code" => 409,
                                    "message" =>  $dataResponse['message'],
                                    "data" => null,
                                );
                            }
                        }
                    } else {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "El almacen ingresado no existe",
                            "validations" => array(
                                "almacenOrigen" => "Ingrese un almacen valido",
                            ),
                            "data" => null
                        );
                    }
                }
            }
            $this->response($response, $response['status_code']);
        }
    }

    //actualizar ls datos en la bd
    function traspasos_put()
    {
        $data = $this->put();
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('movimientos', array('movimientoId' => $id), TRUE);
            if ($dataExists['data']) {
                $almacenOrigen = $dataExists['data']->almacenOrigen;
                $almacenDestino = $dataExists['data']->almacenDestino;
                $movimientoContenidoAntes = $dataExists['data']->movimientoCantidad;
                if (count($this->put()) > 30) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "movimientoFecha" => "El campo fecha es requerido.",
                            "movimientoCantidad" => "El campo cantidad es requerido.",
                            "movimientoNotas" => "El campo notas es opcional"
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "movimientoFecha" => "El campo fecha es requerido.",
                            "movimientoCantidad" => "El campo cantidad es requerido.",
                            "movimientoNotas" => "El campo notas es opcional"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('movimientoFecha', 'fecha', 'required');
                    $this->form_validation->set_rules('movimientoCantidad', 'cantidad', 'required|callback_cantidad_valid');
                    $this->form_validation->set_message('required', 'El campo {field} es requerido.');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->put(),
                            "data" => null
                        );
                    } else {

                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $movimientoFecha = $data["movimientoFecha"];
                        $movimientoCantidad = $data["movimientoCantidad"];
                        $movimientoNotas = $data["movimientoNotas"];

                        $contenidoAlmacenOrigen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenOrigen), TRUE);
                        if ($contenidoAlmacenOrigen['data']) {
                            $cantidadAlmacenOrigen = $contenidoAlmacenOrigen['data']->contenidoCantidad;
                            $totalAlmacenOrigen = $cantidadAlmacenOrigen + $movimientoContenidoAntes;
                            if ($movimientoCantidad > $totalAlmacenOrigen) {
                                $response = array(
                                    "status" => "error",
                                    "status_code" => 409,
                                    "message" => "Validaciones fallidas",
                                    "data" => null,
                                    "validations" => array(
                                        "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar la actualización de una salida, por favor verifique la cantidad",
                                    )
                                );
                            } else {
                                $dataTraspaso = array(
                                    "movimientoFecha" => $movimientoFecha,
                                    "movimientoCantidad" => $movimientoCantidad,
                                    "movimientoNotas" => (@$movimientoNotas) ? $movimientoNotas : "",
                                    "movimientoUsuarioActualizacion" => (@$data["movimientoUsuarioActualizacion"]) ? $data["movimientoUsuarioActualizacion"] : '',
                                    "movimientoFechaActualizacion" => $currentDate,
                                );
                                $responseTraspaso = $this->DAO->updateData('movimientos', $dataTraspaso, array('movimientoId' => $id));
                                if ($responseTraspaso['status'] == 'success') {
                                    $dataDetalles = array(
                                        'detalleCantidad' => $movimientoCantidad,
                                        'detallesFechaActualizacion' => $currentDate
                                    );
                                    $responseDetalles = $this->DAO->updateData('detalles_movimientos', $dataDetalles, array('movimiento_id' => $id));
                                    if ($responseDetalles['status'] == 'success') {
                                        $contenidoAlmacenDestino = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenDestino), TRUE);
                                        $cantidadAlmacenDestino = $contenidoAlmacenDestino['data']->contenidoCantidad;
                                        $totalCantidadAlmacenDestino = ($cantidadAlmacenDestino + $movimientoCantidad) - ($movimientoContenidoAntes);
                                        $dataContenidoDestino = array(
                                            "contenidoCantidad" => $totalCantidadAlmacenDestino,
                                            "contenidoFechaActualizacion" => $currentDate
                                        );
                                        $responseContenidoAlmacenDestino = $this->DAO->updateData('contenido_almacen', $dataContenidoDestino, array('almacenID' => $almacenDestino));
                                        if ($responseContenidoAlmacenDestino['status'] == 'success') {
                                            $totalCantidadAlmacenOrigen = $totalAlmacenOrigen - $movimientoCantidad;
                                            $dataContenidoOrigen = array(
                                                "contenidoCantidad" => $totalCantidadAlmacenOrigen,
                                                "contenidoFechaActualizacion" => $currentDate
                                            );
                                            $responseContenidoAlmacenOrigen = $this->DAO->updateData('contenido_almacen', $dataContenidoOrigen, array('almacenID' => $almacenOrigen));
                                            if ($responseContenidoAlmacenOrigen['status'] == 'success') {
                                                $response = array(
                                                    "status" => "success",
                                                    "status_code" => 200,
                                                    "message" =>  "Traspaso actualizado exitosamente",
                                                    "data" => null,
                                                );
                                            } else {
                                                $response = array(
                                                    "status" => "error",
                                                    "status_code" => 409,
                                                    "message" =>  $responseContenidoAlmacenOrigen['message'],
                                                    "data" => $responseContenidoAlmacenOrigen,
                                                );
                                            }
                                        } else {
                                            $response = array(
                                                "status" => "error",
                                                "status_code" => 409,
                                                "message" =>  $responseContenidoAlmacenDestino['message'],
                                                "data" => null,
                                            );
                                        }
                                    } else {
                                        $response = array(
                                            "status" => "error",
                                            "status_code" => 409,
                                            "message" =>  $responseDetalles['message'],
                                            "data" => null,
                                        );
                                    }
                                } else {
                                    $response = array(
                                        "status" => "error",
                                        "status_code" => 409,
                                        "message" =>  $responseTraspaso['message'],
                                        "data" => null,
                                    );
                                }
                            }
                        } else {
                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" => "El almacen ingresado no existe",
                                "validations" => array(
                                    "almacenOrigen" => "Ingrese un almacen valido",
                                ),
                                "data" => $dataExists
                            );
                        }
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function traspasosDelete_put()
    {
        $id = $this->get('id');
        $tranfersData = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('movimientos', array('movimientoId' => $id), TRUE);
            if ($dataExists['data']) {
                $almacenOrigen = $dataExists['data']->almacenOrigen;
                $almacenDestino = $dataExists['data']->almacenDestino;
                $movimientoContenido = $dataExists['data']->movimientoCantidad;
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "movimientoStatus" => 0,
                    "movimientoUsuarioActualizacion"=>(@$tranfersData["movimientoUsuarioActualizacion"]) ? $tranfersData["movimientoUsuarioActualizacion"] : '',
                    "movimientoFechaActualizacion" => $currentDate
                );
                $responseMovimiento = $this->DAO->updateData('movimientos', $data, array('movimientoId' => $id));
                if ($responseMovimiento['status'] == 'success') {
                    $contenidoAlmacenOrigen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenOrigen), TRUE);
                    $cantidadAlmacenOrigen = $contenidoAlmacenOrigen['data']->contenidoCantidad;
                    $totalAlmacenOrigen = $cantidadAlmacenOrigen + $movimientoContenido;
                    $dataContenidoOrigen = array(
                        "contenidoCantidad" => $totalAlmacenOrigen,
                        "contenidoFechaActualizacion" => $currentDate
                    );
                    $responseContenidoAlmacenOrigen = $this->DAO->updateData('contenido_almacen', $dataContenidoOrigen, array('almacenID' => $almacenOrigen));
                    if ($responseContenidoAlmacenOrigen['status'] == 'success') {
                        $contenidoAlmacenDestimo = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenDestino), TRUE);
                        $cantidadAlmacenDestino = $contenidoAlmacenDestimo['data']->contenidoCantidad;
                        $totalAlmacenDestimo = $cantidadAlmacenDestino - $movimientoContenido;
                        $dataContenidoDestino = array(
                            "contenidoCantidad" => $totalAlmacenDestimo,
                            "contenidoFechaActualizacion" => $currentDate
                        );
                        $responseContenidoAlmacenDestino = $this->DAO->updateData('contenido_almacen', $dataContenidoDestino, array('almacenID' => $almacenDestino));
                        if ($responseContenidoAlmacenDestino['status'] == 'success') {
                            $response = array(
                                "status" => "success",
                                "status_code" => 200,
                                "message" =>  "Traspaso eliminado exitosamente",
                                "data" => null,
                            );
                        } else {
                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" =>  $responseContenidoAlmacenDestino['message'],
                                "data" => null,
                            );
                        }
                    } else {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" =>  $responseContenidoAlmacenOrigen['message'],
                            "data" => null,
                        );
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $responseMovimiento['message'],
                        "data" => null,
                    );
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El movimiento especificado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id del movimiento no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    /* CUSTOMS VALIDATIONS */
    function almacen_exists($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $almacenExists = $this->DAO->selectEntity('almacenes', array('almacenId' => $str), TRUE);
            if ($almacenExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('almacen_exists', 'El campo {field} no existe, por favor ingrese un almacen que se encuentre registrado.');
                return FALSE;
            }
        }
    }

    function cantidad_valid($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {

            if ($str > 0) {
                return TRUE;
            } else {
                $this->form_validation->set_message('cantidad_valid', 'El campo {field} debe ser mayor a 0.');
                return FALSE;
            }
        }
    }
}
