<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->library('ciqrcode');
    }

    //actualizar ls datos en la bd
    function usuarios_personal_info_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('usuario', array('id_usuario' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 10) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "nombre_usuario" => "Requerido",
                            "apellido_paterno_usuario" => "Requerido",
                            "apellido_materno_usuario" => "Opcional",
                            "telefono_usuario" => "Opcional"
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "nombre_usuario" => "Requerido",
                            "apellido_paterno_usuario" => "Requerido",
                            "apellido_materno_usuario" => "Opcional",
                            "telefono_usuario" => "Opcional"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('nombre_usuario', 'nombre_usuario', 'required');
                    $this->form_validation->set_rules('apellido_paterno_usuario', 'apellido_paterno_usuario', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "nombre_usuario" => $this->put('nombre_usuario'),
                            "apellido_paterno" => $this->put('apellido_paterno_usuario'),
                            "apellido_materno" => $this->put('apellido_materno_usuario'),
                            "telefono_usuario" => $this->put('telefono_usuario'),
                            "usuarios_update" => $currentDate
                        );

                        $this->DAO->saveOrUpdateItem('usuario', $data, array('id_usuario' => $id));
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Usuario actualizado exitosamente",
                            "validations" => array(
                                "id" => "Requerido",
                            ),
                            "data" => null
                        );
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    //actualizar ls datos en la bd
    function usuarios_cuenta_info_post()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('usuario', array('id_usuario' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->post()) > 10) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "email_usuario" => "Requerido",
                            "foto_usuario" => "Opcional"
                        ),
                        "data" => null
                    );
                } else if (count($this->post()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "email_usuario" => "Requerido",
                            "foto_usuario" => "Opcional"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->post());
                    $this->form_validation->set_rules('email_usuario', 'email_usuario', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');

                        $file = 'user-' . $id;
                        $config['upload_path'] = 'uploads/user_photos/';
                        $config['allowed_types'] = '*';
                        $config['max_size'] = '0';
                        $config['overwrite'] = TRUE;
                        $config['file_name'] = $file;
                        $this->load->library('upload', $config);
                        if ($this->upload->do_upload("foto_usuario")) {
                            $doc_data = array('upload_data' => $this->upload->data());
                            $imagen = $doc_data['upload_data']['file_name'];
                        } else {
                            $imagen = '';
                        }
                        $data = array(
                            "img_perfil" => $imagen,
                            "email" => $this->post('email_usuario'),
                            "usuarios_update" => $currentDate
                        );

                        $this->DAO->updateData('usuario', $data, array('id_usuario' => $id));
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Usuario actualizado exitosamente",
                            "validations" => array(
                                "id" => "Requerido",
                            ),
                            "data" => null
                        );
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function cambiar_password_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('usuario', array('id_usuario' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 10) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "password_actual" => "Requerido",
                            "password_nueva" => "Requerido",
                            "password_confirmar" => "Requerido"
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "password_actual" => "Requerido",
                            "password_nueva" => "Requerido",
                            "password_confirmar" => "Requerido"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('password_actual', 'password_actual', 'required');
                    $this->form_validation->set_rules('password_nueva', 'password_nueva', 'required');
                    $this->form_validation->set_rules('password_confirmar', 'password_confirmar', 'required|matches[password_nueva]');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "password" => $this->put('password_nueva'),
                            "usuarios_update" => $currentDate
                        );

                        $this->DAO->saveOrUpdateItem('usuario', $data, array('id_usuario' => $id));
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Contraseña actualizada exitosamente",
                            "validations" => array(
                                "id" => "Requerido",
                            ),
                            "data" => null
                        );
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
}
