<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
    $this->load->model('VentasModelo');
  }
  function ventas_folios_get()
  {
    $ventas = $this->DAO->selectEntity('ventas');
    foreach ($ventas['data'] as $i => $venta) {
      $i += 1;
      $ventaID = $venta->id_venta;
      $year = date('y',strtotime($venta->fecha));
      $day = date('d',strtotime($venta->fecha));
      $month = date('m',strtotime($venta->fecha));
      $f_id = str_pad($i, 7, "0", STR_PAD_LEFT);
      $folio = "V$day$month$year-$f_id";
      $data = array(
        "folio_venta" => $folio,
      );
      $response = $this->DAO->saveOrUpdateItem('ventas', $data, array('id_venta' => $ventaID));
    }
    $response = array(
      "status" => "success",
      "status_code" => 200,
      "message" => "Folios de ventas modificados con exito.",
      "data" => null
    );
    $this->response($response, $response['status_code']);
  }

  function ventas_get()
  {
    $id = $this->get('id');
    $limit = $this->get('limit');
    $offset = $this->get('offset');
    $draw = $this->get('draw');
    if (count($this->get()) > 4) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => " Se enviaron demasiados parámetros",
        "validations" => array(
          "id" => "Enviar Id (Obtener) para obtener los datos de la venta en especifico, o vacío para obtener todas las ventas"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_vens', array('id_venta' => $id, 'is_order' => 2), FALSE);
      } else if ($limit) {
        $response = $this->VentasModelo->obtenerVentasPaginacion($offset, $limit, $draw);
      } else {
        $response = $this->DAO->selectEntity('vw_vens', array('is_order' => 2), FALSE, 'id_venta');
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ventas_huevo_get()
  {
    $page = $this->get('page');
    $limit = $this->get('limit');
    $id = $this->get('id');
    if (count($this->get()) > 3) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => " Se enviaron demasiados parámetros",
        "validations" => array(
          "id" => "Enviar Id (Obtener) para obtener los datos de la venta en especifico, o vacío para obtener todas las ventas"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('Vw_Ventas', array('id_venta' => $id), TRUE);
      } else {
        $response = $this->VentasModelo->obtenerVentasHuevo($page, $limit);
      }
    }
    $this->response($response, $response['status_code']);
  }
  
  function ventas_huevo_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 11) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No se recibieron datos' : 'Se recibieron demasiados datos',
        "data" => count($data),
        "validations" => array(
          "id_cliente" => "El campo cliente es requerido.",
          "fecha" => "El campo fecha es requerido.",
          "notas_venta" => "El campo notas opcional.",
          "presentacion" => "El campo presentacion es requerido.",
          "cantidad" => "El campo cantidad es requerido.",
          "precio" => "El campo precio es requerido.",
          "subtotal" => "El campo subtotal es requerido.",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('id_cliente', 'cliente', 'required|callback_client_exists');
      $this->form_validation->set_rules('fecha', 'fecha', 'required');
      /*$this->form_validation->set_rules('presentacion', 'presentacion', 'required');
      $this->form_validation->set_rules('cantidad', 'cantidad', 'required');
      $this->form_validation->set_rules('precio', 'precio', 'required');
      $this->form_validation->set_rules('subtotal', 'subtotal', 'required');*/
      $this->form_validation->set_message('required', 'El campo {field} es requerido.');

      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        //$subtotal = $this->post('subtotal');
        $total=0;
        foreach($this->post('ventasProductos') as $i => $val){
          $total += $val['subtotal'];
        }
        $id_cliente = $this->post('id_cliente');
        $producto = 18;
        $ventas = array(
          "folio_venta" => $this->generarFolio($this->post('fecha')),
          "id_cliente" => $this->post('id_cliente'),
          "tipo_venta" => 2,
          "is_order" => 2,
          "total" => $total,
          "fecha" => $this->post('fecha'),
          "status" => 3,
          "notas_venta" => $this->post('notas_venta'),
          "id_pago" => 1,
          "ventas_create" => $currentDate,
          "ventas_update" => $currentDate
        );
        $ventasResponse = $this->DAO->saveOrUpdateItem('ventas', $ventas, null, true);
        if ($ventasResponse['key']) {
          $id_venta = $ventasResponse['key'];
          foreach($this->post('ventasProductos') as $i => $val){
            $dataPV = array(
              'id_venta' => $id_venta,
              'id_producto' => $producto,
              'cantidad' => $val['cantidad'],
              "presentacion" => $val['presentacion'],
              "precio" => $val['precio'],
              "grapa" => '',
              "arete" => '',
              'tipo' => 'kg',
              'tamaño' => '',
              'subtotal' => $val['subtotal'],
              'productoVenta_create' => $currentDate,
              'productoVenta_update' => $currentDate
            );
            $pvResponse = $this->DAO->saveOrUpdateItem('productos_venta', $dataPV, null, true);  
          }
          
          if ($pvResponse['status'] == 'success') {
            $response = array(
              "status" => "success",
              "status_code" => 200,
              "message" =>  "Venta creada exitosamente",
              "data" => null
            );
          }
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $ventasResponse['message'],
            "data" => null,
          );
        }
      }
      $this->response($response, $response['status_code']);
    }
  }
  
    public function generarFolio($fecha)
  {
    $query_id = $this->db->query("SELECT RIGHT(folio_venta, 7) as folio FROM ventas ORDER BY id_venta DESC LIMIT 1")->row();
    if ($query_id) {
      $folio = $query_id->folio + 1;
    } else {
      $folio = 1;
    }
    $year = date('y', strtotime($fecha));
    $day = date('d', strtotime($fecha));
    $month = date('m', strtotime($fecha));
    $f_id = str_pad($folio, 7, "0", STR_PAD_LEFT);
    $folio = "V$day$month$year-$f_id";
    return $folio;
  }

  
  function product_sales_huevo_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('productos_venta', array('id_producto_venta' => $id), TRUE);
      if ($dataExists['data']) {
        $ventaId = $dataExists['data']->id_venta;
        if (count($this->put()) > 30) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "cantidad" => "El campo cantidad es requerido.",
              "precio" => "El campo precio es requerido.",
              "subtotal" => "El campo subtotal requerido.",
              "presentacion" => "El campo presentación requerido."
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "cantidad" => "El campo cantidad es requerido.",
              "precio" => "El campo precio es requerido.",
              "subtotal" => "El campo subtotal requerido.",
              "presentacion" => "El campo presentación requerido."
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('presentacion', 'presentación', 'required');
          $this->form_validation->set_rules('cantidad', 'cantidad', 'required');
          $this->form_validation->set_rules('precio', 'precio', 'required');
          $this->form_validation->set_rules('subtotal', 'subtotal', 'required');
          $this->form_validation->set_message('required', 'El campo {field} es requerido.');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $producto = 18;
            $data = array(
              'id_producto' => $producto,
              'cantidad' => $this->put('cantidad'),
              "precio" => $this->put('precio'),
              "presentacion" => $this->put('presentacion'),
              'subtotal' => $this->put('subtotal'),
              'productoVenta_update' => $currentDate

            );

            $dataResponse = $this->DAO->saveOrUpdateItem('productos_venta', $data, array('id_producto_venta' => $id));
            if ($dataResponse['status'] == 'success') {
              $ventaTotal = $this->db->query("SELECT SUM(subtotal) as total_venta FROM `productos_venta` WHERE id_venta={$ventaId}")->row();
              $venta = array(
                'total' => $ventaTotal->total_venta,
                'ventas_update' => $currentDate
              );
              $response = $this->DAO->saveOrUpdateItem('ventas', $venta, array('id_venta' => $ventaId));
            } else {
              $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" =>  'No se ha podido actualizar la información',
                "data" => null,
              );
            }
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  
  function ventas_post()
  {
    $data = $this->post();

    if (count($data) == 0 || count($data) > 10) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No se recibieron datos' : 'Se recibieron demasiados datos',
        "data" => count($data),
        "validations" => array(
          "fecha" => "Este dato es requerido",
          "total" => "Este dato es requerido",
          "status" => "Este dato es requerido",
          "id_usuario" => "ESte dato no ha sido registrado previamente"
          /* "id_pago"=>"Registrado previamente" */
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('fecha', 'fecha', 'required');

      $this->form_validation->set_rules('total', 'total', 'required');
      $this->form_validation->set_rules('status', 'status', 'required');
      $this->form_validation->set_rules('id_usuario', 'id_usuario', 'required|callback_brand_exists');
      /* $this->form_validation->set_rules('id_pago', 'id_pago', 'required|callback_category_exists'); */
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {


        $ventas = array(
          "fecha" => $this->post('fecha'),
          "total" => $this->post('total'),
          "status" => $this->post('status'),
          "id_usuario" => $this->post('id_usuario')
        );
        $materialResponse = $this->DAO->saveOrUpdateItem('ventas', $ventas, null, true);
        if ($materialResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "Venta creada created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $materialResponse['message'],
            "data" => null,
          );
        }
      }
    }


    $this->response($response, $response['status_code']);
  }

  function productosV_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 10) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "fecha" => "Este dato es requerido",
              "total" => "Este dato es requerido",
              "status" => "Este dato es requerido",
              "id_usuario" => "ESte dato no ha sido registrado previamente"
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "fecha" => "Este dato es requerido",
              "total" => "Este dato es requerido",
              "status" => "Este dato es requerido",
              "id_usuario" => "ESte dato no ha sido registrado previamente"
            ),
            "data" => null
          );
        } else {

          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('fecha', 'fecha', 'required');
          $this->form_validation->set_rules('total', 'total', 'required');
          $this->form_validation->set_rules('status', 'status', 'required');
          $this->form_validation->set_rules('id_usuario', 'id_usuario', 'required|callback_brand_exists');

          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $data = array(
              "fecha" => $this->put('fecha'),
              "total" => $this->put('total'),
              /*"current_stock"=>$this->put('stock'),*/
              "status" => $this->put('status'),
              "id_usuario" => $this->put('id_usuario')

            );
            $response = $this->DAO->saveOrUpdateItem('ventas', $data, array('id_venta' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function productosV_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
      if ($dataExists['data']) {
        $response = $this->DAO->deleteData('ventas', array('id_venta' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the id of venta does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  
    function ventas_disabled_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $venta = array(
          'is_active' => 0,
          'ventas_update' => $currentDate
        );
        $ventaResponse = $this->DAO->updateData('ventas', $venta, array('id_venta' => $id));
        if ($ventaResponse['status'] == 'success') {
          $productoVenta = array(
            'status' => 0,
            'productoVenta_update' => $currentDate
          );
          $response = $this->DAO->updateData('productos_venta', $productoVenta, array('id_venta' => $id));
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $ventaResponse['message'],
            "data" => null,
          );
        }
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "El id ingresado no existe como venta",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  
   function client_exists($str)
  {
    if (strlen($str) == 0) {
      return true;
    }
    if (strlen($str) >= 1  && strlen($str) <= 45) {
      $clientExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $str), TRUE);
      if ($clientExists['data']) {
        return TRUE;
      } else {
        $this->form_validation->set_message('client_exists', '{field} no existe, por favor ingrese un cliente que se encuentre registrado.');
        return FALSE;
      }
    }
  }

  /**exta validations**/
}
