<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }

       function ventas_internas_get()
    {
        $id = $this->get('id');
        $ventaId = $this->get('ventaId');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener los datos de la venta en especifico, o vacío para obtener todas las ventas"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_vens', array('id_venta' => $id), true);
            } else if ($ventaId) {
                $response = $this->DAO->selectEntity('ventas', array('id_venta' => $ventaId), true);
            } else {
                $response = $this->DAO->selectEntity('ventas', array('is_order' => 2), FALSE, 'id_venta');
            }
        }
        $this->response($response, $response['status_code']);
    }


    function productSales_get()
    {
        $id = $this->get('id');
        $idSale =  $this->get('sale');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific weaning, or empty to get all weanings"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_ver', array('id_producto_venta' => $id), TRUE);
            } else if ($idSale) {
                $response = $this->DAO->selectEntity('vw_ver', array('status' => '1', 'id_venta'=> $idSale ));
            }else{
                $response = $this->DAO->selectEntity('vw_ver', array('status' => '1'));
            }
        }
        $this->response($response, $response['status_code']);
    }

 public function generarFolio($fecha)
    {
        $query_id = $this->db->query("SELECT RIGHT(folio_venta, 7) as folio FROM ventas ORDER BY id_venta DESC LIMIT 1")->row();
        if ($query_id) {
            $folio = $query_id->folio + 1;
        } else {
            $folio = 1;
        }
        $year = date('y',strtotime($fecha));
        $day = date('d', strtotime($fecha));
        $month = date('m', strtotime($fecha));
        $f_id = str_pad($folio, 7, "0", STR_PAD_LEFT);
        $folio = "V$day$month$year-$f_id";
        return $folio;
    }
        function generar_recibo_temporal($sale_id)
    {
        $sale  = $this->DAO->selectEntity('vw_vens', array('id_venta' => $sale_id), false)['data'];
        $products_sale = $this->DAO->selectEntity('vw_ver', array('id_venta' => $sale_id), false)['data'];
        $product = $products_sale[0]->nombre_producto;
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
        $header = $this->load->view('ventas/recibo_ventas/header', array('sale' => $sale[0]), true);
        $mpdf->SetHTMLHeader($header);
        $footer = $this->load->view('ventas/recibo_ventas/footer', [], true);
        $mpdf->SetHTMLFooter($footer);
        $html = $this->load->view('ventas/recibo_ventas/body', array('products_sale' => $products_sale, 'product' => $product), true);
        $css = file_get_contents('assets/pdf-recipie.css');
        $mpdf->SetTitle('Recibo de venta ' . $sale[0]->folio_venta);
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');



        $mpdf->Output('tmp/RECIBO.pdf', 'F');

       
    }
      function enviar_recibo_email_post()
    {
        $id_venta = $this->get('ventaId');
        if ($id_venta) {
            $this->generar_recibo_temporal($id_venta);
            $venta = $this->DAO->selectEntity('ventas', array('id_venta' => $id_venta), true)['data'];
            $cliente = $this->DAO->selectEntity('clientes', array('id_cliente' => $venta->id_cliente), true)['data'];

            $config = array(
                'protocol' => 'smtp',
                'smtp_host' => 'ssl://smtp.hostinger.com',
                'smtp_port' => 465,
                'smtp_user' => 'ventas@ranchoelarenal.com.mx', // change it to yours
                'smtp_pass' => 'Ventas@rancho123', // change it to yours
                'newline' => "\r\n",
                'mailtype' => 'html',
                'charset' => "utf-8",
                'wordwrap' => TRUE,
                'priority' => '1',
            );
            $message = 'Gracias por comprar con nosotros, Rancho El Arenal agradece su preferencia. ';
            $this->load->library('email', $config);
            $this->email->set_newline("\r\n");
            $this->email->from('ventas@ranchoelarenal.com.mx', 'Ventas Rancho el Arenal'); // 
            $this->email->to('ventas@ranchoelarenal.com.mx'); // 
            $correo_cliente = ($cliente->email_cliente) ? $cliente->email_cliente . ',' : '';
            $this->email->cc($correo_cliente . 'administracion@ranchoelarenal.com.mx,recursoshumanos@ranchoelarenal.com.mx');
            $this->email->subject('Recibo de venta ' . $venta->folio_venta);
            $this->email->attach('tmp/RECIBO.pdf', 'attachment', 'RECIBO-' . $venta->folio_venta . '.pdf');
            $this->email->message($message);
            if ($this->email->send()) {
                $dataVenta = array(
                    'status_envio_recibo' => 1
                );
                $this->DAO->saveOrUpdateItem('ventas', $dataVenta, array('id_venta' => $id_venta));
                $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" =>  "Envio de recibo exitoso",
                    "data" => null
                );
            } else {

                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" =>  'No se pudo enviar el correo',
                    "data" => var_dump($this->email->print_debugger()),
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function ventas_internas_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 11) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Se recibieron demasiados datos',
                "data" => count($data),
                "validations" => array(
                    "id_cliente" => "Campo requerido.",
                    "fecha" => "Campo requerido."
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('id_cliente', 'id_cliente', 'required|callback_client_exists');
            $this->form_validation->set_rules('fecha', 'fecha', 'required');
            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $total1 = 0;
                $subtotal = $this->post('total');

                foreach ($subtotal as $s) {
                    $total1 = $total1 + $s;
                }
                $id_cliente = $this->post('id_cliente');
                $ventas = array(
                    "folio_venta" => $this->generarFolio($this->post('fecha')),
                    "id_cliente" => $this->post('id_cliente'),
                    "tipo_venta" => 2,
                    "is_order" => 2,
                    "total" => $total1,
                    "fecha" => $this->post('fecha'),
                    "status" => 3,
                    "notas_venta" => $this->post('notas_venta'),
                    "id_pago" => 1,
                    "ventas_create" => $currentDate,
                    "ventas_update" => $currentDate
                );
                $ventasResponse = $this->DAO->saveOrUpdateItem('ventas', $ventas, null, true);
                if ($ventasResponse['key']) {
                    $id_venta = $ventasResponse['key'];
                    foreach ($data['id_prod'] as $i => $val) {
                        
                       
                            $presentacion_=(isset($data['presentacion'][$i])) ? $data['presentacion'][$i]:'';
                    
                        
                        $dataPV = array(
                            'id_venta' => $id_venta,
                            'id_producto' => $val,
                            'cantidad' => $data['kilos'][$i],
                             "presentacion" => $presentacion_,
                            "precio" => $data['precio'][$i],
                            "grapa" => $data['grapa'][$i],
                            "arete" => $data['arete'][$i],
                            'tipo' => 'kg',
                            'tamaño' => '',
                            'subtotal' => $data['total'][$i],
                            'productoVenta_create' => $currentDate,
                            'productoVenta_update' => $currentDate
                        );
                        $pvResponse = $this->DAO->saveOrUpdateItem('productos_venta', $dataPV, null, true);
                    }
                    if ($pvResponse['status'] == 'success') {
                          $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Venta creada exitosamente",
                            "data" => null
                        );
                     /*   $this->generar_recibo_temporal($id_venta);
                        $cliente = $this->DAO->selectEntity('clientes', array('id_cliente' => $id_cliente), true)['data'];
                        $venta = $this->DAO->selectEntity('ventas', array('id_venta' => $id_venta), true)['data'];
                           $config = array(
                            'protocol' => 'smtp',
                            'smtp_host' => 'ssl://smtp.hostinger.com',
                            'smtp_port' => 465,
                            'smtp_user' => 'ventas@ranchoelarenal.com.mx', // change it to yours
                            'smtp_pass' => 'Ventas@rancho123', // change it to yours
                            'newline' => "\r\n",
                            'mailtype' => 'html',
                            'charset' => "utf-8",
                            'wordwrap' => TRUE,
                            'priority' => '1',
                        );
                        $message = 'Gracias por comprar con nosotros, Rancho El Arenal agradece su preferencia. ';
                        $this->load->library('email', $config);
                        $this->email->set_newline("\r\n");
                        $this->email->from('ventas@ranchoelarenal.com.mx', 'Ventas Rancho el Arenal'); // 
                        $this->email->to('ventas@ranchoelarenal.com.mx'); // 
                        $correo_cliente=($cliente->email_cliente) ? $cliente->email_cliente.',' : '';
                        $this->email->cc($correo_cliente.'administracion@ranchoelarenal.com.mx,recursoshumanos@ranchoelarenal.com.mx');
                //joaquin.r93250@gmail.com,
                        $this->email->subject('Recibo de venta ' . $venta->folio_venta);
                        $this->email->attach('tmp/RECIBO.pdf', 'attachment', 'RECIBO-' . $venta->folio_venta . '.pdf');
                        $this->email->message($message);
                        if ($this->email->send()) {
                            $response = array(
                                "status" => "success",
                                "status_code" => 200,
                                "message" =>  "Venta creada exitosamente",
                                "data" => null
                            );
                        } else {

                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" =>  'No se pudo enviar el correo',
                                "data" => var_dump($this->email->print_debugger()),
                            );
                        } */
                   
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $ventasResponse['message'],
                        "data" => null,
                    );
                }
            }
            $this->response($response, $response['status_code']);
        }
    }

    function ventas_Excel1_post()
    {
        $data = $this->post();
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');

        $dataAnimal = array(
            "folio_venta" => strtoupper('rea' . random_string('alnum', 4)),
            "id_cliente" =>$data['id_cliente'],
            "tipo_venta" => 2,
            "is_order" => 2,
            "total" => 1,
            "fecha" => $data['id_cliente'],
            "status" => 3,
            "id_pago" => 1,
            "ventas_create" => $currentDate,
            "ventas_update" => $currentDate

        ); 

        $dataResponse = $this->DAO->saveOrUpdateBatchItems('productos_venta', $dataAnimal);
        if ($dataResponse['status'] == "success") {
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" =>  "item created successfully",
                "data" => null,
            );
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" =>  $dataResponse['message'],
                "data" => null,
            );
        }
        $this->response($response, $response['status_code']);
    }


    function ventas_Excel_post()
    {
                 $data = $this->post();
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $total1 = 0;
                $ventas = array(
                    "folio_venta" => strtoupper('rea' . random_string('alnum', 4)),
                    "id_cliente" => $data['id_cliente'],
                    "tipo_venta" => 2,
                    "is_order" => 2,
                    "total" => $total1,
                    "fecha" => $data['fecha'],
                    "status" => 3,
                    "id_pago" => 1,
                    "ventas_create" => $currentDate,
                    "ventas_update" => $currentDate
                );
                $ventasResponse = $this->DAO->saveOrUpdateItem('ventas', $ventas, null, true);
                if ($ventasResponse['key']) {
                    $id_venta = $ventasResponse['key'];
                    foreach ($data['productos'] as $i => $val) {
                        $dataPV = array(
                            'id_venta' => $id_venta,
                            'id_producto' => $val,
                            'cantidad' => $data['kilos'][$i],
                            "precio" => $data['precio'][$i],
                            "grapa" => $data['grapa'][$i],
                            "arete" => $data['arete'][$i],
                            'tipo' => 'kg',
                            'tamaño' => '',
                            'subtotal' => $data['total'][$i],
                            'productoVenta_create' => $currentDate,
                            'productoVenta_update' => $currentDate
                        );
                        $pvResponse = $this->DAO->saveOrUpdateItem('productos_venta', $dataPV, null, true);
                    }
                    if ($pvResponse['status'] == 'success') {
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Venta creada exitosamente",
                            "data" => $data,
                        );
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $ventasResponse['message'],
                        "data" => null,
                    );
                }
        }
    



function ventas_internas_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
            if ($dataExists) {
                if (count($this->put()) > 30) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados.",
                        "validations" => array(
                            "id_cliente" => "El campo cliente es requerido.",
                            "fecha" => "El campo fecha es requerido."

                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningún dato fue enviado.",
                        "validations" => array(
                            "id_cliente" => "El campo cliente es requerido.",
                            "fecha" => "El campo fecha es requerido."
                        ),
                        "data" => null
                    );
                } else {
                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('id_cliente', 'cliente', 'required|callback_client_exists');
                    $this->form_validation->set_rules('fecha', 'fecha', 'required');
                    $this->form_validation->set_message('required', 'El campo {field} es requerido.');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "folio_venta" => $this->put('folio_venta'),
                            "id_cliente" => $this->put('id_cliente'),
                            "total" => $this->put('total'),
                            "fecha" => $this->put('fecha'),
                            "notas_venta" => $this->put('notas_venta'),
                            "ventas_update" => $currentDate

                        );

                        $response = $this->DAO->saveOrUpdateItem('ventas', $data, array('id_venta' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados parametros fueron enviados.",
                "validations" => array(
                    "id" => "El id de la venta es requerido GET(id)",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


function product_sales_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos_venta', array('id_producto_venta' => $id), TRUE);
            if ($dataExists['data']) {
                $ventaId=$dataExists['data']->id_venta;
                if (count($this->put()) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Too many data was sent",
                        "validations" => array(
                            "cantidad" => "Campo requerido.",
                            "precio" => "Campo requerido.",
                            "subtotal" => "Campo requerido."
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "No data was sent",
                        "validations" => array(
                            "id_producto" => "Campo requerido.",
                            "cantidad" => "Campo requerido.",
                            "precio" => "Campo requerido.",
                            "subtotal" => "Campo requerido."
                        ),
                        "data" => null
                    );
                } else {
                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('id_producto', 'id_producto', 'required');
                    $this->form_validation->set_rules('cantidad', 'cantidad', 'required');
                    $this->form_validation->set_rules('precio', 'precio', 'required');
                    $this->form_validation->set_rules('subtotal', 'subtotal', 'required');
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $newSubtProd=$this->put('subtotal');
                        $data = array(
                            'id_producto' => $this->put('id_producto'),
                            'cantidad' => $this->put('cantidad'),
                            "precio" => $this->put('precio'),
                            "grapa" => $this->put('grapa'),
                            "arete" => $this->put('arete'),
                            'tipo' => 'kg',
                            'tamaño' => '',
                            'subtotal' => $this->put('subtotal'),
                            'productoVenta_create' => $currentDate,
                            'productoVenta_update' => $currentDate

                        );

                        $dataResponse = $this->DAO->saveOrUpdateItem('productos_venta', $data, array('id_producto_venta' => $id));
                        if ($dataResponse['status']=='success'){
                            $ventaTotal=$this->db->query("SELECT SUM(subtotal) as total_venta FROM `productos_venta` WHERE id_venta={$ventaId}")->row();
                            $venta=array(
                                'total'=>$ventaTotal->total_venta,
                                'ventas_update'=>$currentDate
                            );
                            $response = $this->DAO->saveOrUpdateItem('ventas', $venta, array('id_venta' => $ventaId));
                        }else{
                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" =>  'No se ha podido actualizar la información',
                                "data" => null,
                            );
                        }
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }



    function updateTotal_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
            if ($dataExists) {
                if (count($this->put()) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Too many data was sent",
                        "validations" => array(
                            "total" => "Campo requerido."
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "No data was sent",
                        "validations" => array(
                            "total" => "Campo requerido."
                        ),
                        "data" => null
                    );
                } else {
                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('total', 'total', 'required');
                    
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');

                        $data = array(

                            "total" => $this->put('total'),
                            "ventas_update" => $currentDate

                        );

                        $response = $this->DAO->saveOrUpdateItem('ventas', $data, array('id_venta' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function productSales_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('productos_venta', array('id_producto_venta' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $treatment = array(
                    'status' => 0,
                    'productoVenta_update' => $currentDate
                );
                $response = $this->DAO->updateData('productos_venta', $treatment, array('id_producto_venta' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of the productSales does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function client_exists($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $clientExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $str), TRUE);
            if ($clientExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('client_exists', '{field} no existe, por favor ingrese un cliente que se encuentre registrado.');
                return FALSE;
            }
        }
    }


}
