<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class DAO extends CI_Model{
	function __construct(){
        parent::__construct();
    }
        function insertData($entityName,$data){
        $this->db->insert($entityName,$data);

        $resposeDB = array(
            "status"=>"success",
            "status_code"=>200,
            "validations"=>null,
            "message"=>"registro correcto"
        );
                return $resposeDB;


    }

    function selectEntity($entityName, $whereClause = NULL, $isUnique = FALSE, $orderBy = NULL){
    	if($whereClause){
    		$this->db->where($whereClause);
    	}
    	  if ($orderBy) {
            $this->db->order_by($orderBy, 'DESC');
        }
    	$query = $this->db->get($entityName);
    	if($this->db->error()['message']!=""){
    		$reponseDB = array(
    			"status"=>"error",
    			"status_code"=>409,
    			"message"=>"Db error: ".$this->db->error()['message'],
    			"validations"=>null,
    			"data"=>null
    		);
    	}else{
    		$reponseDB = array(
    			"status"=>"success",
    			"status_code"=>200,
    			"message"=>"Data loaded, successful",
    			"validations"=>null,
    			"data"=>$isUnique ? $query->row() : $query->result()
    		);
    	}
    	return $reponseDB;
    }

    function selectEntity1($entity, $whereClause = NULL){
    	if($whereClause){
    		$this->db->where($whereClause);

    	}
      $query = $this->db->get($entity);


    	return $whereClause ? $query->row() : $query->result();
    }
    
        function selectEntity2($entityName, $whereClause = NULL, $isUnique = FALSE, $whereOrder=NULL){
    	if($whereClause){
    		$this->db->where($whereClause);
        }
        $this->db->order_by($whereOrder, 'DESC');
    	$query = $this->db->get($entityName);
    	if($this->db->error()['message']!=""){
    		$reponseDB = array(
    			"status"=>"error",
    			"status_code"=>409,
    			"message"=>"Db error: ".$this->db->error()['message'],
    			"validations"=>null,
    			"data"=>null
    		);
    	}else{
    		$reponseDB = array(
    			"status"=>"success",
    			"status_code"=>200,
    			"message"=>"Data loaded, successful",
    			"validations"=>null,
    			"data"=>$isUnique ? $query->row() : $query->result()
    		);
    	}
    	return $reponseDB;
    }
    
  function updateData($entityName,$data,$whereClause){
        $this->db->where($whereClause);
        $this->db->update($entityName,$data);
        if($this->db->error()['message']!=""){
            $reponseDB = array(
                "status"=>"error",
                "status_code"=>409,
                "message"=>"Db error: ".$this->db->error()['message'],
                "validations"=>null,
                "data"=>null
            );
        }else{
            $reponseDB = array(
                "status"=>"success",
                "status_code"=>200,
                "message"=>"Data updated successful",
                "validations"=>null,
                "data"=>null
            );
        }
        return $reponseDB;
    }
   /*  Funcion para obtener el id de la venta */
    function saveOrUpdateItem($entityName,$data,$whereClause = NULL,$generateKey =  FALSE){
        
        if($whereClause){
            $this->db->where($whereClause);
            $this->db->update($entityName,$data);
        }else{
            $this->db->insert($entityName,$data);
        }
        if($this->db->error()['message']!=''){
            $responseDB = array(
                "status"=>"error",
                "status_code"=>409,
                "message"=>$this->db->error()['message']
            );
        }else{
            $responseDB = array(
                "status"=>"success",
                "status_code"=>$whereClause ? 200 : 201,
                "message"=>"Item created Successfully",
                "data"=>$data,
                "key"=>$generateKey ? $this->db->insert_id() : null
            );
        }
        return $responseDB;
    }



    function saveOrUpdateBatchItems($entityName,$data,$whereClause = NULL){  
        if($whereClause){
            
        }else{
            $this->db->insert_batch($entityName,$data);
        }
        if($this->db->error()['message']!=''){
            $responseDB = array(
                "status"=>"error",
                "status_code"=>409,
                "message"=>$this->db->error()['message']
            );
        }else{
            $responseDB = array(
                "status"=>"success",
                "status_code"=>201,
                "message"=>"Item created Successfully"
            );
        }
        return $responseDB;

    }
     function saveOrUpdateBatchIdTitles($entityName,$data,$whereClause = null){

        if($whereClause){

            $this->db->where($whereClause);
            $this->db->update($entityName,$data);

        }else{

            $this->db->insert_batch($entityName,$data);

        }

        if($this->db->error()['message']!=''){
            $responseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => $this->db->error()['message']
            );

        }else{
            $responseDB = array(
                "status" => "success",
                "status_code" => 201,
                "message" => "titles created successfully"
            );
        }
        return $responseDB;
    }


    function deleteData($entityName,$whereClause){
        $this->db->where($whereClause);
        $this->db->delete($entityName);
         if($this->db->error()['message']!=""){
            switch ($this->db->error()['code']) {
                case '1062':
                    $reponseDB = array(
                "status"=>"error",
                "status_code"=>409,
                "message"=>"Duplicate entry error",
                "validations"=>null,
                "data"=>null
            );
                    break;
                    case '1451':
              $reponseDB = array(
                "status"=>"error",
                "status_code"=>409,
                "message"=>"Foreign key error",
                "validations"=>null,
                "data"=>null
            );          
                        break;
                
                default:
                    $reponseDB = array(
                "status"=>"error",
                "status_code"=>409,
                "message"=>"Db error: ".$this->db->error()['message'],
                "validations"=>null,
                "data"=>null
            );
                    break;
            }
            
        }else{
            $reponseDB = array(
                "status"=>"success",
                "status_code"=>200,
                "message"=>"Data deleted successful",
                "validations"=>null,
                "data"=>null
            );
        }
        return $reponseDB;

    }


    function client_log_in($email, $password)
    {
        $this->db->where('email_cliente', $email);
        //$this->db->where('status',1);
        $result = $this->getClientUser($password);
        if (!empty($result)) {
            return $result;
        } else {
            return null;
        }
        
    }
    //$this->load->library('bcrypt');
    function getClientUser($password){
        $query=$this->db->get('clientes');
        if ($query->num_rows() > 0) {
            $result = $query->row_array();
            $this->load->library('bcrypt');
            if ($this->bcrypt->check_password($password, $result['password_cliente'])) {
                return $result;
            } else {
                //contraseña no coincide
                return array();
            }
            
        } else {
            return array();
        }
        
    }
    
    function user_log_in($email, $password)
    {
        $this->db->where('email', $email);
        //$this->db->where('status',1);
        $result = $this->getUser($password);
        if (!empty($result)) {
            return $result;
        } else {
            return null;
        }
        
    }
    //$this->load->library('bcrypt');
    function getUser($password){
        $query=$this->db->get('usuario');
        if ($query->num_rows() > 0) {
            $result = $query->row_array();
            $this->load->library('bcrypt');
            if ($this->bcrypt->check_password($password, $result['password'])) {
                return $result;
            } else {
                //contraseña no coincide
                return array();
            }
            
        } else {
            return array();
        }
        
    }
}