<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Generic_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        //Do your magic here
    }

    /**
     * funcion para insertar datos
     * @param entityName nombre de la tabla en la base de datos
     * @param data array de datos a insertar
     */
    public function insertData($entityName, $data)
    {

        $this->db->insert($entityName, $data);
        if ($this->db->error()['message'] != '') {
            $message = "";
            switch ($this->db->error()['code']) {
                case '1062':
                    # Duplicate entry error
                    $message = 'Entrada duplicada';
                    break;

                default:
                    #default error
                    $message = $this->db->error()['message'];
                    break;
            }
            $this->session->set_flashdata('dbMessage', array("status" => 'danger', "message" => $message));
            return $message;
        } else {

            $this->session->set_flashdata('dbMessage', array("status" => 'success', "message" => "Registro exitoso"));

            return $this->lang->line('insert_db');
        }
    }
    /**
     * funcion para obtener datos
     * @param entityName nombre de la tabla en la base de datos
     * @param whereClause atributos por los cuales se quiere obtener un elemento en especifico
     * @param uniqueResult para especificar si se quiere traer un resultado en especifico o muchos a la vez
     */
    public function selectEntity($entityName, $whereClause = NULL, $uniqueResult = FALSE)
    {
        if ($whereClause) {
            $this->db->where($whereClause);
        }
        $result = $this->db->get($entityName);
        if ($this->db->error()['message'] != '') {
            return null;
        } else {
            if ($uniqueResult) {
                return $result->row();
            } else {
                return $result->result();
            }
        }
    }
    /*RDER BY nombre (s) de campo ASC / DESC [LIMIT N]
    */
    public function selectEntity1($entityName, $whereClause = NULL, $uniqueResult = FALSE, $whereOrder=NULL, $limit=NULL, $start=NULL)
    {
        if ($whereClause) {
            $this->db->where($whereClause);
        }
        $this->db->order_by($whereOrder, 'DESC');
        $this->db->limit($limit, $start);
        $result = $this->db->get($entityName);
        if ($this->db->error()['message'] != '') {
            return null;
        } else {
            if ($uniqueResult) {
                return $result->row();
            } else {
                return $result->result();
            }
        }
    }
    /**
     * funcion para actualizar  datos
     * @param entityName nombre de la tabla en la base de datos
     * @param whereClause identificador de elemto a actualizar
     * @param data elementos a actualizar y informcion que se actualizara
     */
    public function updateData($entityName, $data, $whereClause)
    {
        $this->db->where($whereClause);
        $this->db->update($entityName, $data);
        if ($this->db->error()['message'] != '') {
            $message = "";
            switch ($this->db->error()['code']) {
                case '1062':
                    # Duplicate entry error
                    $message = "Entrada duplicada";
                    break;

                default:
                    #default error
                    $message = $this->db->error()['message'];
                    break;
            }
            $this->session->set_flashdata('dbMessage', array("status" => 'danger', "message" => $message));
            return $message;
        } else {
            $this->session->set_flashdata('dbMessage', array("status" => 'success', "message" => "Actualización exitosa"));
            return $this->lang->line('update_db');
        }
    }

    function deleteData($entityName, $whereClause){
        $this->db->where($whereClause);
        $this->db->delete($entityName);

        if($this->db->error()['message']!=''){
          $message = "";
          switch ($this->db->error()['code']) {
            case '1062':
              # Duplicate entry error
              $message = "Entrada duplicada";
              break;

            case '1451':
              #foreign key error
              $message = "Entrada con llave foranea";
              break;
            default:
              # default error
              $message = $this->db->error()['message'];
              break;
          }
          $this->session->set_flashdata('dbMessage', array("status"=>"danger","message"=>$message));
          return $message;
        }else{
          $this->session->set_flashdata('dbMessage', array("status"=>"success","message"=>"Eliminación exitosa"));
          return "Eliminación exitosa";
        }
      }

      function insertOrder($data)
      {
        $this->db->insert('ventas',$data);
        $id = $this->db->insert_id();
        return $id;
      }
}