<?php

defined('BASEPATH') or exit('No direct script access allowed');

class VentasModelo extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    function obtenerVentasPaginacion($offset = NULL, $limit = NULL, $draw = NULL)
    {
        $this->db->where('is_order', 2);
        $this->db->order_by('id_venta', 'DESC');
        if ($offset != NULL && $limit != NULL) {
            $this->db->limit($limit, $offset);
        }
        $resultData = $this->db->get('vw_vens')->result();
        $totalVentas = $this->db->query('SELECT COUNT(*) AS total FROM vw_vens WHERE is_order=2')->row();
        $ventasData = [];
        foreach ($resultData as $key => $row) {
            $productosVenta = $this->obtenerDetallesProductosVenta($row->id_venta);
            $clienteInfo = $this->obtenerClientePorId($row->id_cliente);
            $ventasData[] = array(
                'id_venta' => $row->id_venta,
                'id_cliente' => $row->id_cliente,
                'tipo_venta' => $row->tipo_venta,
                'tipo_envio' => $row->tipo_envio,
                'is_order' => $row->is_order,
                'total' => $row->total,
                'fecha' => $row->fecha,
                'notas_venta' => $row->notas_venta,
                'comentario_cancelacion' => $row->comentario_cancelacion,
                'status' => $row->status,
                'is_active' => (@$row->is_active) ? $row->is_active : "",
                'ventas_create' => $row->ventas_create,
                'ventas_update' => $row->ventas_update,
                'status1' => $row->status1,
                'status_envio_recibo' => $row->status_envio_recibo,
                'folio_venta' => $row->folio_venta,
                'id_producto' => $row->id_producto,
                'hora' => $row->hora,
                'cantidad_pedido' => $row->cantidad_pedido,
                'tipo_unidad' => $row->tipo_unidad,
                'nombre_cliente' => $row->nombre_cliente,
                'apellido_cliente' => $row->apellido_cliente,
                'apellido_ma_cliente' => $row->apellido_ma_cliente,
                'nombre_completo' => $row->nombre_completo,
                'productosVenta' => $productosVenta,
                'clienteInfo' => $clienteInfo

            );
        }
        $data = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalVentas->total,
            "recordsFiltered" => $totalVentas->total,
            "data" => $ventasData,
        );
        $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $data
        );

        return $reponseDB;
    }
    function obtenerDetallesProductosVenta($ventaId)
    {
        $this->db->where('id_venta', $ventaId);
        $this->db->where('status', 1);
        $productos = $this->db->get('vw_ver')->result();
        return $productos;
    }
    function obtenerClientePorId($clienteId)
    {
        $this->db->where('id_cliente', $clienteId);
        $clienteInfo = $this->db->get('clientes')->row();
        return $clienteInfo;
    }

    function obtenerVentasHuevo($page = NULL, $limit = NULL)
    {
        if ($page != NULL && $limit != NULL) {
            $page_num = max(0, ($page - 1) * $limit);
            /* AND is_active=1
AND is_active=1 */
            $query = $this->db->query("SELECT * FROM `Vw_Ventas` WHERE (tipo_venta = '2') AND (status1 = 3) and (nombre_producto = 'Huevo')  GROUP BY folio_venta  ORDER BY id_venta DESC LIMIT {$page_num}, {$limit} ");
        } else {
            $query = $this->db->query("SELECT * FROM `Vw_Ventas` WHERE (tipo_venta = '2') AND (status1 = 3) and (nombre_producto = 'Huevo')  GROUP BY folio_venta ORDER BY id_venta DESC");
        }
        $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );

        return $reponseDB;
    }
}
